<!-- ************************************************************************
*      SPLAT: An RF Signal Propagation Loss and Terrain Analysis Tool       *
*			  Last update: 15-Mar-2007			    *
*****************************************************************************
*	     Project started in 1997 by John A. Magliacane, KD2BD 	    *
*****************************************************************************
*									    *
*     Extensively modified by J. D. McDonald in Jan. 2004 to include        *
*    the Longley-Rice propagation model using C++ code from NTIA/ITS.	    *
*									    *
*              See: http://flattop.its.bldrdoc.gov/itm.html                 *
*									    *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.								    *
*									    *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.							    *
*									    *
*****************************************************************************
 
*****************************************************************************
*		PHP Graphic User Interface by Charles Escobar               *
*****************************************************************************  
  -->
<script type="text/javascript"><!--//--><![CDATA[//><!--
   
function prepareTargetBlank(){
   var className = 'external';
   var as = document.getElementsByTagName('a');
   for(i=0;i<as.length;i++){
      var a = as[i];
      r=new RegExp("(^| )"+className+"($| )");
      if(r.test(a.className)){
         a.onclick = function(){
            window.open(this.href);
            return false;
         }
      }
    }
}
   
window.onload = prepareTargetBlank;
   
//--><!]]></script>


<HEAD>
  <META http-equiv="Content-Type" content="text/html; charset=utf-8">
  <TITLE>SPLAT! PHP GUI --- A Terrestrial RF Path Analysis Application For
  Linux/Unix</TITLE>
</HEAD>
<BODY bgcolor="#F6E39E" background="./images/mainback.jpg">
<CENTER>
    <FONT face="Luxi Sans" size="4" color="#AF0000"><IMG src="./images/splatlogo.gif" alt="SPLAT! Because The World Isn't Flat"></FONT>
  </CENTER>

<HR noshade>

<?php;

///////////////////////////////
//  PREDICCION DE COBERTURA  //
///////////////////////////////

//borrado de los archivos de cálculos previos
shell_exec('rm -f *.txt *.lro *.lrp *.ppm *.geo *.scf ./geo/* ./klm/* ./lro/*');

//Asegura que la aplicación tiene un solo usuario operándola

$lock = shell_exec("cat ./lock.splat");
if ($lock==0) {
shell_exec('echo 1 > lock.splat'); 


//Determinación de coordenadas sur 
if ($surpred=="ON") { 
$lat_gradopred= -$lat_gradopred; 
$lat_minutopred= -$lat_minutopred;
$lat_segundopred= -$lat_segundopred;
}
$lattx = $lat_gradopred + $lat_minutopred/60  + $lat_segundopred/3600;
$longtx = $long_gradopred + $long_minutopred/60 + $long_segundopred/3600; 
 
//Creación del archivo splat.lrp 
shell_exec('touch splat.lrp');
shell_exec('echo  '.$edc.' "; Earth Dielectric Constant (Relative permittivity)" > splat.lrp');
shell_exec('echo  '.$ec.' "; Earth Conductivity (Siemens per meter)" >> splat.lrp');
shell_exec('echo  '.$abc.' "; Atmospheric Bending Constant (N-Units)" >> splat.lrp');
shell_exec('echo  '.$fmhz.' "; Frequency in MHz (20 MHz to 20 GHz)" >> splat.lrp');
shell_exec('echo  '.$rc.' "; Radio Climate" >> splat.lrp');
shell_exec('echo  '.$pol.' "; Polarization (0 = Horizontal, 1 = Vertical)" >> splat.lrp');
shell_exec('echo  '.$fs.' "; Fraction of situations" >> splat.lrp');
shell_exec('echo  '.$ft.' "; Fraction of time" >> splat.lrp');
shell_exec('echo  '.$erp.' "; Transmitter Effective Radiated Power in Watts (optional)" >> splat.lrp'); 
//shell_exec('echo  "" >> splat.lrp');

//Creación del archivo /tmp/tx_sitepred.scf
if ($SCF=="ON")
{ 
shell_exec('touch /tmp/tx_sitepred.scf');
if ($dB128=="ON") {  
shell_exec('echo  '.$dBu128.'": 255,   0,   0" > /tmp/tx_sitepred.scf');
}
if ($dB118=="ON") {
shell_exec('echo  '.$dBu118.'": 255, 165,   0" >> /tmp/tx_sitepred.scf'); 
}
if ($dB108=="ON") {
shell_exec('echo  '.$dBu108.'": 255, 206,   0" >> /tmp/tx_sitepred.scf'); 
}
if ($dB98=="ON") {
shell_exec('echo  '.$dBu98.'": 255, 255,   0" >> /tmp/tx_sitepred.scf');
}
if ($dB88=="ON") {
shell_exec('echo  '.$dBu88.'": 184, 255,   0" >> /tmp/tx_sitepred.scf');
}
if ($dB78=="ON") {
shell_exec('echo  '.$dBu78.'":   0, 255,   0" >> /tmp/tx_sitepred.scf');
}
if ($dB68=="ON") {
shell_exec('echo  '.$dBu68.'":   0, 208,   0" >> /tmp/tx_sitepred.scf');
}
if ($dB58=="ON") {
shell_exec('echo  '.$dBu58.'":   0, 196, 196" >> /tmp/tx_sitepred.scf');
}
if ($dB48=="ON") {
shell_exec('echo  '.$dBu48.'":   0, 148, 255" >> /tmp/tx_sitepred.scf'); 
}
if ($dB38=="ON") {
shell_exec('echo  '.$dBu38.'":  80,  80, 255" >> /tmp/tx_sitepred.scf');
}
if ($dB28=="ON") {
shell_exec('echo  '.$dBu28.'":   0,  38, 255" >> /tmp/tx_sitepred.scf');
}
if ($dB18=="ON") {
shell_exec('echo  '.$dBu18.'": 142,  63, 255" >> /tmp/tx_sitepred.scf');
}
if ($dB8=="ON") {
shell_exec('echo  '.$dBu8.'": 140,   0, 128" >> /tmp/tx_sitepred.scf'); 
}
}

//Creación del archivo /tmp/tx_sitepred.qth 
shell_exec('touch /tmp/tx_sitepred.qth');
shell_exec('echo  "" > /tmp/tx_sitepred.qth');
$latitudpred=$lat_gradopred ." ". $lat_minutopred ." " . $lat_segundopred; 
$longitudpred=$long_gradopred ." ". $long_minutopred ." " . $long_segundopred; 
$gestor = fopen("/tmp/tx_sitepred.qth", "r+");
fwrite($gestor, $tx_sitepred  , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $latitudpred  , 26); 
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $longitudpred , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $h_txpr . " m" , 26);  
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');


//Creación del archivo /tmp/tx_sitepred2.qth 
if ($txpred2=="ON") {

if ($surtxpred2=="ON") {
$lat_gradotxpred2= -$lat_gradotxpred2;
$lat_minutotxpred2= -$lat_minutotxpred2;
$lat_segundotxpred2= -$lat_segundotxpred2; 
}

shell_exec('touch /tmp/tx_sitepred2.qth');
shell_exec('echo  "" > /tmp/tx_sitepred2.qth');
$latitudtxpred2=$lat_gradotxpred2 ." ". $lat_minutotxpred2 ." " . $lat_segundotxpred2;
$longitudtxpred2=$long_gradotxpred2 ." ". $long_minutotxpred2 ." " . $long_segundotxpred2; 
$gestor = fopen("/tmp/tx_sitepred2.qth", "r+");
fwrite($gestor, $tx_sitepred2  , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred2.qth');
$gestor = fopen("/tmp/tx_sitepred2.qth", "a+");
fwrite($gestor, $latitudtxpred2  , 26); 
shell_exec('echo  "" >> /tmp/tx_sitepred2.qth');
$gestor = fopen("/tmp/tx_sitepred2.qth", "a+");
fwrite($gestor, $longitudtxpred2 , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred2.qth');
$gestor = fopen("/tmp/tx_sitepred2.qth", "a+");
fwrite($gestor, $h_txpred2 . " m" , 26);  
shell_exec('echo  "" >> /tmp/tx_sitepred2.qth');
$txxpred2="/tmp/tx_sitepred2.qth";
}

//Creación del archivo /tmp/tx_sitepred3.qth 
if ($txpred3=="ON") {  

if ($surtxpred3=="ON") {
$lat_gradotxpred3= -$lat_gradotxpred3;
$lat_minutotxpred3= -$lat_minutotxpred3;
$lat_segundotxpred3= -$lat_segundotxpred3;  
}

shell_exec('touch /tmp/tx_sitepred3.qth');
shell_exec('echo  "" > /tmp/tx_sitepred3.qth');
$latitudtxpred3=$lat_gradotxpred3 ." ". $lat_minutotxpred3 ." " . $lat_segundotxpred3;
$longitudtxpred3=$long_gradotxpred3 ." ". $long_minutotxpred3 ." " . $long_segundotxpred3; 
$gestor = fopen("/tmp/tx_sitepred3.qth", "r+");
fwrite($gestor, $tx_sitepred3  , 36);
shell_exec('echo  "" >> /tmp/tx_sitepred3.qth');
$gestor = fopen("/tmp/tx_sitepred3.qth", "a+");
fwrite($gestor, $latitudtxpred3  , 36); 
shell_exec('echo  "" >> /tmp/tx_sitepred3.qth');
$gestor = fopen("/tmp/tx_sitepred3.qth", "a+");
fwrite($gestor, $longitudtxpred3 , 36); 
shell_exec('echo  "" >> /tmp/tx_sitepred3.qth');
$gestor = fopen("/tmp/tx_sitepred3.qth", "a+");
fwrite($gestor, $h_txpred3 . " m" , 36);  
shell_exec('echo  "" >> /tmp/tx_sitepred3.qth');
$txxpred3="/tmp/tx_sitepred3.qth";
} 

//Creación del archivo /tmp/tx_sitepred4.qth 
if ($txpred4=="ON") { 

if ($surtxpred4=="ON") {
$lat_gradotxpred4= -$lat_gradotxpred4;
$lat_minutotxpred4= -$lat_minutotxpred4;
$lat_segundotxpred4= -$lat_segundotxpred4;  
}

shell_exec('touch /tmp/tx_sitepred4.qth');
shell_exec('echo  "" > /tmp/tx_sitepred4.qth');
$latitudtxpred4=$lat_gradotxpred4 ." ". $lat_minutotxpred4 ." " . $lat_segundotxpred4;
$longitudtxpred4=$long_gradotxpred4 ." ". $long_minutotxpred4 ." " . $long_segundotxpred4; 
$gestor = fopen("/tmp/tx_sitepred4.qth", "r+");
fwrite($gestor, $tx_sitepred4  , 46);
shell_exec('echo  "" >> /tmp/tx_sitepred4.qth');
$gestor = fopen("/tmp/tx_sitepred4.qth", "a+");
fwrite($gestor, $latitudtxpred4  , 46); 
shell_exec('echo  "" >> /tmp/tx_sitepred4.qth');
$gestor = fopen("/tmp/tx_sitepred4.qth", "a+");
fwrite($gestor, $longitudtxpred4 , 46); 
shell_exec('echo  "" >> /tmp/tx_sitepred4.qth');
$gestor = fopen("/tmp/tx_sitepred4.qth", "a+");
fwrite($gestor, $h_txpred4 . " m" , 46);  
shell_exec('echo  "" >> /tmp/tx_sitepred4.qth');
$txxpred4="/tmp/tx_sitepred4.qth";
} 


//Cálculos de acuerdo a la selección de opciones por el usuario 

$splat="splat";

if ($metric=="ON") {
$metric="-metric"; 
}

if ($sb==ON) {
$sb="-b limites.dat -s sitios.dat";
}

if ($LRC=="ON") { 
$LRC="-R"; 
$RC=$Rc; 
} 

if ($LRL=="ON") { 
$LRL="-R";
$RL=$Rl;  
}

if ($DB=="ON") {  
$DB="-db"; 
$DBL=$Dbl;  
} 

if ($LRX=="ON") {
$LRX="-R";
$RX=$Rx;
}  

if ($geo=="ON") {
$GEO="-geo";
}	

if ($geol=="ON") { 
$GEOL="-geo";	 
}	  

if ($kml=="ON") { 
$KML="-kml";	 
}

if ($olditm=="ON") { 
$OLDITM="-olditm";	 
}

if ($AZI=="ON") {
shell_exec('cp azimut.az splat.az; cp azimut.az /tmp/tx_sitepred.az');
}	
else {
shell_exec('rm splat.az; rm /tmp/tx_sitepred.az');
} 
		
	//Cálculo de cobertura ITM o Longley-Rice
	$L="ON"; 
	if ($L=="ON") {
	
			echo "$splat -t /tmp/tx_sitepred.qth $sb -d /opt/splat/sdf  $metric  -m $radio -olditm -L $Ll $LRL $RL  $OLDITM $DB $DBL $GEOL -o temporales/longleyrice.ppm"; 				 
			shell_exec(''.$splat.' -t /tmp/tx_sitepred.qth '.$sb.' -d /opt/splat/sdf  '.$metric.'  -m '.$radio.' '.$OLDITM.' -L '.$Ll.' -erp '.$erp.' '.$DB.' '.$DBL.' '.$LRL.'  '.$RL.' '.$GEOL.' -o temporales/longleyrice.ppm > coveragearea.html');  

shell_exec('convert temporales/longleyrice.ppm -resize 640x640 temporales/longleyrice.png'); 

echo "<center><h4>Mapa topográfico de  cobertura ITM o Longley-Rice&nbsp;&nbsp;<a href='./ayuda/ayudappmlr.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br>(Click sobre el mapa para descargarlo)</br><a href='temporales/longleyrice.ppm'><img align = 'center' src='temporales/longleyrice.png' border=0></a><br></br></center>";
			echo "<br></br>";


if ($trans=="ON") {
shell_exec(''.$splat.' -t /tmp/tx_sitepred.qth '.$sb.' -d /opt/splat/sdf  '.$metric.'  -m '.$radio.' '.$OLDITM.' -L '.$Ll.' -erp '.$erp.' '.$DB.' '.$DBL.' '.$LRL.'  '.$RL.' '.$GEOL.' '.$KML.' -ngs -o temporales/longleyricewhite.ppm  > coveragearea.html');

shell_exec('convert -transparent "#FFFFFF" temporales/longleyricewhite.ppm temporales/longleyricewhitetr.png');
shell_exec('convert temporales/longleyricewhite.ppm -resize 640x640 temporales/longleyricewhitet.png');

echo "<center><h4>Mapa topográfico de  cobertura ITM o Longley-Rice Transparente&nbsp;&nbsp;<a href='./ayuda/ayudappmlr.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br>(Click sobre el mapa para descargarlo)</br><a href='temporales/longleyricewhitetr.png'><img align = 'center' src='temporales/longleyricewhitet.png' border=0></a><br></br></center>";
                        echo "<br></br>";

if ($kml=="ON") { 
echo "<center><h3>Archivos para Googleearth&nbsp;&nbsp;</a></h3></center>";
echo "<center>Descargue los siguientes archivos en una misma carpeta y abra el archivo .kml con Googleearth &nbsp;&nbsp;</a></center>";
echo "<center><h4><a href='./temporales/longleyricewhitetr.kml'>Descargar archivo KML para Googleearth&nbsp;&nbsp;</a></h4></center>";
echo "<center><h4><a href='./temporales/longleyricewhite-ck.ppm'>Descargar archivo CK-PPM para Googleearth&nbsp;&nbsp;</a></h4></center>";
echo "<center><h4><a href='./temporales/longleyricewhitetr.png'>Descargar archivo de transparencia para Googleearth&nbsp;&nbsp;</a></h4></center>";
shell_exec('sed s/"temporales\/longleyricewhite.ppm"/longleyricewhitetr.png/g temporales/longleyricewhite.kml > temporales/longleyricewhitet.kml');
shell_exec('sed s/"temporales\/longleyricewhite-ck.ppm"/longleyricewhite-ck.ppm/g temporales/longleyricewhitet.kml > temporales/longleyricewhitetr.kml');
}
			

		}

}	

echo "<HR noshade>";	

if ($geo=="ON") {

shell_exec('mv *geo geo/');
echo "<center><h4>Archivos de Georeferencia para el programa Xastir&nbsp;&nbsp;<a href='./ayuda/ayudappmxr.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><a href=./geo/><img align = 'center' src='./images/download.png' border=0></a><br></br></center>"; 
				echo "<br></br>";

}	

shell_exec('echo 0 > lock.splat');
	
//Fin del condicionante lock.splat
}
else {
echo "<h1 color: ff0000>La aplicación está siendo utilizada, por favor inténtelo mas tarde</h1>";
}
?>  

<br></br>

<form action="splat.php" method="post">
<input type="submit" name="Volver" value="VOLVER"> 
</form>
