<!-- ************************************************************************
*      SPLAT: An RF Signal Propagation Loss and Terrain Analysis Tool       *
*			  Last update: 15-Mar-2007			    *
*****************************************************************************
*	     Project started in 1997 by John A. Magliacane, KD2BD 	    *
*****************************************************************************
*									    *
*     Extensively modified by J. D. McDonald in Jan. 2004 to include        *
*    the Longley-Rice propagation model using C++ code from NTIA/ITS.	    *
*									    *
*              See: http://flattop.its.bldrdoc.gov/itm.html                 *
*									    *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.								    *
*									    *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.							    *
*									    *
*****************************************************************************
 
*****************************************************************************
*		PHP Graphic User Interface by Charles Escobar               *
*****************************************************************************  
  -->
<script type="text/javascript"><!--//--><![CDATA[//><!--
   
function prepareTargetBlank(){
   var className = 'external';
   var as = document.getElementsByTagName('a');
   for(i=0;i<as.length;i++){
      var a = as[i];
      r=new RegExp("(^| )"+className+"($| )");
      if(r.test(a.className)){
         a.onclick = function(){
            window.open(this.href);
            return false;
         }
      }
    }
}
   
window.onload = prepareTargetBlank;
   
//--><!]]></script>


<HEAD>
  <META http-equiv="Content-Type" content="text/html; charset=utf-8">
  <TITLE>SPLAT! PHP GUI --- A Terrestrial RF Path Analysis Application For
  Linux/Unix</TITLE>
</HEAD>
<BODY bgcolor="#F6E39E" background="./images/mainback.jpg">
<CENTER>
    <FONT face="Luxi Sans" size="4" color="#AF0000"><IMG src="./images/splatlogo.gif" alt="SPLAT! Because The World Isn't Flat"></FONT>
  </CENTER>

<HR noshade>

<?php;

///////////////////////////////
//  PREDICCION DE COBERTURA  //
///////////////////////////////

//borrado de los archivos de cálculos previos
shell_exec('rm -f *.txt *.txt *.lrp *.ppm *.geo *.scf ./geo/* ./klm/* ./txt/*');

//Asegura que la aplicación tiene un solo usuario operándola

$lock = shell_exec("cat ./lock.splat");
if ($lock==0) {
shell_exec('echo 1 > lock.splat'); 


//Determinación de coordenadas sur 
if ($surpred=="ON") { 
$lat_gradopred= -$lat_gradopred; 
$lat_minutopred= -$lat_minutopred;
$lat_segundopred= -$lat_segundopred;
}
$lattx = $lat_gradopred + $lat_minutopred/60  + $lat_segundopred/3600;
$longtx = $long_gradopred + $long_minutopred/60 + $long_segundopred/3600; 
 
//Creación del archivo /tmp/splat.lrp 
shell_exec('touch splat.lrp');
shell_exec('echo  '.$edc.' "; Earth Dielectric Constant (Relative permittivity)" > splat.lrp');
shell_exec('echo  '.$ec.' "; Earth Conductivity (Siemens per meter)" >> splat.lrp');
shell_exec('echo  '.$abc.' "; Atmospheric Bending Constant (N-Units)" >> splat.lrp');
shell_exec('echo  '.$fmhz.' "; Frequency in MHz (20 MHz to 20 GHz)" >> splat.lrp');
shell_exec('echo  '.$rc.' "; Radio Climate" >> splat.lrp');
shell_exec('echo  '.$pol.' "; Polarization (0 = Horizontal, 1 = Vertical)" >> splat.lrp');
shell_exec('echo  '.$fs.' "; Fraction of situations" >> splat.lrp');
shell_exec('echo  '.$ft.' "; Fraction of time" >> splat.lrp');
shell_exec('echo  '.$erp.' "; Transmitter Effective Radiated Power in Watts (optional)" >> splat.lrp'); 
//shell_exec('echo  "" >> splat.lrp');



//Creación del archivo /tmp/tx_sitepred.qth 
shell_exec('touch /tmp/tx_sitepred.qth');
shell_exec('echo  "" > /tmp/tx_sitepred.qth');
$latitudpred=$lat_gradopred ." ". $lat_minutopred ." " . $lat_segundopred; 
$longitudpred=$long_gradopred ." ". $long_minutopred ." " . $long_segundopred; 
$gestor = fopen("/tmp/tx_sitepred.qth", "r+");
fwrite($gestor, $tx_sitepred  , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $latitudpred  , 26); 
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $longitudpred , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $h_txpr . " m" , 26);  
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');


//Cálculos de acuerdo a la selección de opciones por el usuario 

if ($metric=="ON") {
$metric="-metric"; 
}


if ($LRC=="ON") { 
$LRC="-R"; 
$RC=$Rc; 
} 

if ($LRL=="ON") { 
$LRL="-R";
$RL=$Rl;  
}

if ($DB=="ON") {  
$DB="-db"; 
$DBL=$Dbl;  
} 

if ($LRX=="ON") {
$LRX="-R";
$RX=$Rx;
}  

if ($geo=="ON") {
$GEO="-geo";
}	

if ($geol=="ON") { 
$GEOL="-geo";	 
}	  
		
	//Cálculo de cobertura LDV  
	
	//Cálculo de cobertura Longley-Rice 
	

 
	if ($perfiles=="ON") { 
			$dezp=0.53965407;
			shell_exec('cp /tmp/tx_sitepred.qth /var/www/splat/txprofile.qth');
			
			shell_exec('echo perfil de 0 grados > rxprofile.qth'); 
			$latrx0=$lattx+$dezp;
			$longrx0=$longtx;
			shell_exec('echo '.$latrx0.' >> rxprofile.qth');  
			shell_exec('echo '.$longrx0.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil0.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl0.png'); 
			
			
			shell_exec('echo perfil de 180 grados > rxprofile.qth'); 
			$latrx180=$lattx-$dezp ;
			$longrx180=$longtx;
			shell_exec('echo '.$latrx180.' >> rxprofile.qth');
			shell_exec('echo '.$longrx180.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil180.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl180.png');
			
			shell_exec('echo perfil de 90 grados > rxprofile.qth');
			$latrx90=$lattx;
			$longrx90=$longtx-$dezp; 
			shell_exec('echo '.$latrx90.' >> rxprofile.qth');
			shell_exec('echo '.$longrx90.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil90.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl90.png');
			
			shell_exec('echo perfil de 270 grados > rxprofile.qth');
			$latrx270=$lattx;
			$longrx270=$longtx+$dezp; 
			shell_exec('echo '.$latrx270.' >> rxprofile.qth');
			shell_exec('echo '.$longrx270.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil270.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl270.png');
			
			$a=0.269827035;
			$b=0.467354134;
			
			shell_exec('echo perfil de 30 grados > rxprofile.qth');
			$latrx30=$lattx+$b;
			$longrx30=$longtx-$a; 
			shell_exec('echo '.$latrx30.' >> rxprofile.qth');
			shell_exec('echo '.$longrx30.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil30.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl30.png');
			
			shell_exec('echo perfil de 60 grados > rxprofile.qth');
			$latrx60=$lattx+$a;  
			$longrx60=$longtx-$b; 
			shell_exec('echo '.$latrx60.' >> rxprofile.qth');
			shell_exec('echo '.$longrx60.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil60.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl60.png'); 
			
			shell_exec('echo perfil de 120 grados > rxprofile.qth');
			$latrx120=$lattx-$a; 
			$longrx120=$longtx-$b;
			shell_exec('echo '.$latrx120.' >> rxprofile.qth');
			shell_exec('echo '.$longrx120.' >> rxprofile.qth'); 
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil120.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl120.png');
			
			shell_exec('echo perfil de 150 grados > rxprofile.qth');
			$latrx150=$lattx-$b;
			$longrx150=$longtx-$a; 
			shell_exec('echo '.$latrx150.' >> rxprofile.qth'); 
			shell_exec('echo '.$longrx150.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil150.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl150.png');
			
			shell_exec('echo perfil de 210 grados > rxprofile.qth');
			$latrx210=$lattx-$b;
			$longrx210=$longtx+$a; 
			shell_exec('echo '.$latrx210.' >> rxprofile.qth');
			shell_exec('echo '.$longrx210.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth'); 
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil210.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl210.png');
			
			shell_exec('echo perfil de 240 grados > rxprofile.qth');  
			$latrx240=$lattx-$a;  
			$longrx240=$longtx+$b; 
			shell_exec('echo '.$latrx240.' >> rxprofile.qth');
			shell_exec('echo '.$longrx240.' >> rxprofile.qth'); 
			shell_exec('echo 10 m >> rxprofile.qth'); 
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil240.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl240.png');
			
			shell_exec('echo perfil de 300 grados > rxprofile.qth');
			$latrx300=$lattx+$a ;
			$longrx300=$longtx+$b; 
			shell_exec('echo '.$latrx300.' >> rxprofile.qth');
			shell_exec('echo '.$longrx300.' >> rxprofile.qth'); 
			shell_exec('echo 10 m >> rxprofile.qth');
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil300.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl300.png');
			
			shell_exec('echo perfil de 330 grados > rxprofile.qth');
			$latrx330=$lattx+$b;
			$longrx330=$longtx+$a; 
			shell_exec('echo '.$latrx330.' >> rxprofile.qth');
			shell_exec('echo '.$longrx330.' >> rxprofile.qth');
			shell_exec('echo 10 m >> rxprofile.qth'); 
			shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil330.png');
			shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl330.png');	
	
			echo "<h3>Perfiles topográficos cada 30º</h3>";			
			echo "<center><h4>Perfil de 0º</h4></a></h4></br><img align = 'center' src='perfil0.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 30º</h4></a></h4></br><img align = 'center' src='perfil30.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 60º</h4></a></h4></br><img align = 'center' src='perfil60.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 90º</h4></a></h4></br><img align = 'center' src='perfil90.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 120º</h4></a></h4></br><img align = 'center' src='perfil120.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 150º</h4></a></h4></br><img align = 'center' src='perfil150.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 180º</h4></a></h4></br><img align = 'center' src='perfil180.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 210º</h4></a></h4></br><img align = 'center' src='perfil210.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 240º</h4></a></h4></br><img align = 'center' src='perfil240.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 270º</h4></a></h4></br><img align = 'center' src='perfil270.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 300º</h4></a></h4></br><img align = 'center' src='perfil300.php' border=0><br></br></center>";
			echo "<center><h4>Perfil de 330º</h4></a></h4></br><img align = 'center' src='perfil330.php' border=0><br></br></center>";

			echo "<h3>Atenuación cada 30º</h3>";			
			echo "<center><h4>Atenuación de 0º</h4></a></h4></br><img align = 'center' src='attn0.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 30º</h4></a></h4></br><img align = 'center' src='attn30.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 60º</h4></a></h4></br><img align = 'center' src='attn60.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 90º</h4></a></h4></br><img align = 'center' src='attn90.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 120º</h4></a></h4></br><img align = 'center' src='attn120.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 150º</h4></a></h4></br><img align = 'center' src='attn150.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 180º</h4></a></h4></br><img align = 'center' src='attn180.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 210º</h4></a></h4></br><img align = 'center' src='attn210.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 240º</h4></a></h4></br><img align = 'center' src='attn240.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 270º</h4></a></h4></br><img align = 'center' src='attn270.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 300º</h4></a></h4></br><img align = 'center' src='attn300.php' border=0><br></br></center>";
			echo "<center><h4>Atenuación de 330º</h4></a></h4></br><img align = 'center' src='attn330.php' border=0><br></br></center>";
			
			shell_exec('cat *_0_grados.txt > atenuaciones.ttxt; cat *30_grados.txt >> atenuaciones.ttxt; cat *60_grados.txt >> atenuaciones.ttxt; cat *90_grados.txt >> atenuaciones.ttxt; cat *120_grados.txt >> atenuaciones.ttxt; cat *150_grados.txt >> atenuaciones.ttxt; cat *180_grados.txt >> atenuaciones.ttxt; cat *210_grados.txt >> atenuaciones.ttxt; cat *240_grados.txt >> atenuaciones.ttxt; echo *270_grados.txt >> atenuaciones.ttxt; cat *300_grados.txt >> atenuaciones.ttxt; cat *330_grados.txt >> atenuaciones.ttxt');
			
			echo "<center><h4>Descargar Archivo de Atenuaciones&nbsp;&nbsp;<a href='./ayuda/ayudappm.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><a href='atenuaciones.ttxt'><img align = 'center' src='./images/download.png' border=0></a><br></br></center>";

	}	 
shell_exec('echo 0 > lock.splat');
	
//Fin del condicionante lock.splat
}
else {
echo "<h1 color: ff0000>La aplicación está siendo utilizada, por favor inténtelo mas tarde</h1>";
}
?>  

<br></br>

<form action="splat.php" method="post">
<input type="submit" name="Volver" value="VOLVER"> 
</form>
