<!-- ************************************************************************
*      SPLAT: An RF Signal Propagation Loss and Terrain Analysis Tool       *
*	 Last update: 15-Mar-2007	   *
*****************************************************************************
*	    Project started in 1997 by John A. Magliacane, KD2BD    *
*****************************************************************************
*	   *
*     Extensively modified by J. D. McDonald in Jan. 2004 to include        *
*    the Longley-Rice propagation model using C++ code from NTIA/ITS.	   *
*	   *
*              See: http://flattop.its.bldrdoc.gov/itm.html                 *
*	   *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.	   *
*	   *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.	   *
*	   *
*****************************************************************************
 
*****************************************************************************
*	PHP Graphic User Interface by Charles Escobar               *
*****************************************************************************  
  -->
<script type="text/javascript"><!--//--><![CDATA[//><!--
   
function prepareTargetBlank(){
   var className = 'external';
   var as = document.getElementsByTagName('a');
   for(i=0;i<as.length;i++){
      var a = as[i];
      r=new RegExp("(^| )"+className+"($| )");
      if(r.test(a.className)){
         a.onclick = function(){
            window.open(this.href);
            return false;
         }
      }
    }
}
   
window.onload = prepareTargetBlank;
   
//--><!]]></script>


<HEAD>
  <META http-equiv="Content-Type" content="text/html; charset=utf-8">
  <TITLE>SPLAT! PHP GUI --- A Terrestrial RF Path Analysis Application For
  Linux/Unix</TITLE>
</HEAD>
<BODY bgcolor="#F6E39E" background="./images/mainback.jpg">
<CENTER>
    <FONT face="Luxi Sans" size="4" color="#AF0000"><IMG src="./images/splatlogo.gif" alt="SPLAT! Because The World Isn't Flat"></FONT>
  </CENTER>

<HR noshade>

<?php;

///////////////////////////////
//  PREDICCION DE COBERTURA  //
///////////////////////////////

//borrado de los archivos de cálculos previos
shell_exec('rm -f *.txt *.ttxt *.lrp *.ppm *.geo *.scf ./geo/* ./klm/* ./txt/*');

//Asegura que la aplicación tiene un solo usuario operándola

$lock = shell_exec("cat ./lock.splat");
if ($lock==0) {
shell_exec('echo 1 > lock.splat'); 


//Determinación de coordenadas sur 
if ($surpred=="ON") { 
$lat_gradopred= -$lat_gradopred; 
$lat_minutopred= -$lat_minutopred;
$lat_segundopred= -$lat_segundopred;
}
$lattx = $lat_gradopred + $lat_minutopred/60  + $lat_segundopred/3600;
$longtx = $long_gradopred + $long_minutopred/60 + $long_segundopred/3600; 
 
//Creación del archivo /tmp/splat.lrp 
shell_exec('touch splat.lrp');
shell_exec('echo  '.$edc.' "; Earth Dielectric Constant (Relative permittivity)" > splat.lrp');
shell_exec('echo  '.$ec.' "; Earth Conductivity (Siemens per meter)" >> splat.lrp');
shell_exec('echo  '.$abc.' "; Atmospheric Bending Constant (N-Units)" >> splat.lrp');
shell_exec('echo  '.$fmhz.' "; Frequency in MHz (20 MHz to 20 GHz)" >> splat.lrp');
shell_exec('echo  '.$rc.' "; Radio Climate" >> splat.lrp');
shell_exec('echo  '.$pol.' "; Polarization (0 = Horizontal, 1 = Vertical)" >> splat.lrp');
shell_exec('echo  '.$fs.' "; Fraction of situations" >> splat.lrp');
shell_exec('echo  '.$ft.' "; Fraction of time" >> splat.lrp');
shell_exec('echo  '.$erp.' "; Transmitter Effective Radiated Power in Watts (optional)" >> splat.lrp'); 
//shell_exec('echo  "" >> splat.lrp');



//Creación del archivo /tmp/tx_sitepred.qth 
shell_exec('touch /tmp/tx_sitepred.qth');
shell_exec('echo  "" > /tmp/tx_sitepred.qth');
$latitudpred=$lat_gradopred ." ". $lat_minutopred ." " . $lat_segundopred; 
$longitudpred=$long_gradopred ." ". $long_minutopred ." " . $long_segundopred; 
$gestor = fopen("/tmp/tx_sitepred.qth", "r+");
fwrite($gestor, $tx_sitepred  , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $latitudpred  , 26); 
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $longitudpred , 26);
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');
$gestor = fopen("/tmp/tx_sitepred.qth", "a+");
fwrite($gestor, $h_txpr . " m" , 26);  
shell_exec('echo  "" >> /tmp/tx_sitepred.qth');


//Cálculos de acuerdo a la selección de opciones por el usuario 

if ($metric=="ON") {
$metric="-metric"; 
}


if ($LRC=="ON") { 
$LRC="-R"; 
$RC=$Rc; 
} 

if ($LRL=="ON") { 
$LRL="-R";
$RL=$Rl;  
}

if ($DB=="ON") {  
$DB="-db"; 
$DBL=$Dbl;  
} 

if ($LRX=="ON") {
$LRX="-R";
$RX=$Rx;
}  

if ($geo=="ON") {
$GEO="-geo";
}	

if ($geol=="ON") { 
$GEOL="-geo";	 
}	 
//Cálculo de cobertura LDV  
//Cálculo de cobertura Longley-Rice 

 
if ($perfiles=="ON") { 

shell_exec('cp /tmp/tx_sitepred.qth /var/www/splat/txprofile.qth');

//0º
for ( $i = 5 ; $i <= 100 ; $i +=5) {
//$dezp=0.53965407;
$dezp = 0.0089942345 * $i;


shell_exec('echo "perfil de 0 grados" > rxprofile.qth'); 
$latrx0=$lattx+$dezp;
$longrx0=$longtx;
shell_exec('echo '.$latrx0.' >> rxprofile.qth');  
shell_exec('echo '.$longrx0.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');	
shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl0.png'); 
shell_exec('cat '.$tx_sitepred.'-to-perfil_de_0_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones0.ttxt');


if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil0.png');
}


}; //cierra for	


//45º

for ( $i = 5 ; $i <= 100 ; $i +=5) {

//$a=0.38159305239192;
$dezpl=0.0063598842;
$a=$dezpl*$i;
$b=$a;
shell_exec('echo perfil de 45 grados > rxprofile.qth');
$latrx45=$lattx+$b;
$longrx45=$longtx-$a; 
shell_exec('echo '.$latrx45.' >> rxprofile.qth');
shell_exec('echo '.$longrx45.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');

shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl45.png');

shell_exec('cat '.$tx_sitepred.'-to-perfil_de_45_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones45.ttxt');

if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil45.png');
}

}; //cierra for	


//90º
for ( $i = 5 ; $i <= 100 ; $i +=5) {
//$dezp=0.53965407;
$dezp = 0.0089942345 * $i;


shell_exec('echo "perfil de 90 grados" > rxprofile.qth'); 
$latrx90=$lattx;
$longrx90=$longtx-$dezp;
shell_exec('echo '.$latrx90.' >> rxprofile.qth');  
shell_exec('echo '.$longrx90.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');	
shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl90.png'); 
shell_exec('cat '.$tx_sitepred.'-to-perfil_de_90_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones90.ttxt');


if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil90.png');
}


}; //cierra for	

//135º

for ( $i = 5 ; $i <= 100 ; $i +=5) {

//$a=0.38159305239192;
$dezpl=0.0063598842;
$a=$dezpl*$i;
$b=$a;
shell_exec('echo perfil de 135 grados > rxprofile.qth');
$latrx135=$lattx-$b;
$longrx135=$longtx-$a; 
shell_exec('echo '.$latrx135.' >> rxprofile.qth');
shell_exec('echo '.$longrx135.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');

shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl135.png');

shell_exec('cat '.$tx_sitepred.'-to-perfil_de_135_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones135.ttxt');

if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil135.png');
}

}; //cierra for	



////
//180º
shell_exec('cat " " > atenuaciones180.ttxt');
for ( $i = 5 ; $i <= 100 ; $i +=5) {
//$dezp=0.53965407;
$dezp = 0.0089942345 * $i;


shell_exec('echo "perfil de 180 grados" > rxprofile.qth'); 
$latrx180=$lattx-$dezp;
$longrx180=$longtx;
shell_exec('echo '.$latrx180.' >> rxprofile.qth');  
shell_exec('echo '.$longrx180.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');	
shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl180.png'); 
shell_exec('cat '.$tx_sitepred.'-to-perfil_de_180_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones180.ttxt');


if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil180.png');
}

}; //cierra for	

//225º

for ( $i = 5 ; $i <= 100 ; $i +=5) {

//$a=0.38159305239192;
$dezpl=0.0063598842;
$a=$dezpl*$i;
$b=$a;
shell_exec('echo perfil de 225 grados > rxprofile.qth');
$latrx225=$lattx-$b;
$longrx225=$longtx+$a; 
shell_exec('echo '.$latrx225.' >> rxprofile.qth');
shell_exec('echo '.$longrx225.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');

shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl225.png');

shell_exec('cat '.$tx_sitepred.'-to-perfil_de_225_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones225.ttxt');

if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil225.png');
}

}; //cierra for	


//270º
for ( $i = 5 ; $i <= 100 ; $i +=5) {
//$dezp=0.53965407;
$dezp = 0.0089942345 * $i;


shell_exec('echo "perfil de 270 grados" > rxprofile.qth'); 
$latrx270=$lattx;
$longrx270=$longtx+$dezp;
shell_exec('echo '.$latrx270.' >> rxprofile.qth');  
shell_exec('echo '.$longrx270.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');	
shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl270.png'); 
shell_exec('cat '.$tx_sitepred.'-to-perfil_de_270_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones270.ttxt');


if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil270.png');
}


}; //cierra for	


//315º

for ( $i = 5 ; $i <= 100 ; $i +=5) {

//$a=0.38159305239192;
$dezpl=0.0063598842;
$a=$dezpl*$i;
$b=$a;
shell_exec('echo perfil de 315 grados > rxprofile.qth');
$latrx315=$lattx+$b;
$longrx315=$longtx+$a; 
shell_exec('echo '.$latrx315.' >> rxprofile.qth');
shell_exec('echo '.$longrx315.' >> rxprofile.qth');
shell_exec('echo 10 m >> rxprofile.qth');

shell_exec('splat -r rxprofile.qth -t txprofile.qth -d /opt/splat/sdf  '.$metric.' -l /tmp/attnprfl315.png');

shell_exec('cat '.$tx_sitepred.'-to-perfil_de_315_grados.txt|grep "Field strength"|cut -d " " -f 8 >> atenuaciones315.ttxt');

if( $i > 97 ) {
shell_exec('splat -t rxprofile.qth -r txprofile.qth -d /opt/splat/sdf  '.$metric.' -nf -H  /tmp/perfil315.png');
}

}; //cierra for	


echo "<h3>Perfiles topográficos cada 45º</h3>";	
echo "<center><h4>Perfil de 0º</h4></a></h4></br><img align = 'center' src='perfil0.php' border=0><br></br></center>";
echo "<center><h4>Perfil de 45º</h4></a></h4></br><img align = 'center' src='perfil45.php' border=0><br></br></center>";
echo "<center><h4>Perfil de 90º</h4></a></h4></br><img align = 'center' src='perfil90.php' border=0><br></br></center>";
echo "<center><h4>Perfil de 135º</h4></a></h4></br><img align = 'center' src='perfil135.php' border=0><br></br></center>";
echo "<center><h4>Perfil de 180º</h4></a></h4></br><img align = 'center' src='perfil180.php' border=0><br></br></center>";
echo "<center><h4>Perfil de 225º</h4></a></h4></br><img align = 'center' src='perfil225.php' border=0><br></br></center>";
echo "<center><h4>Perfil de 270º</h4></a></h4></br><img align = 'center' src='perfil270.php' border=0><br></br></center>";
echo "<center><h4>Perfil de 315º</h4></a></h4></br><img align = 'center' src='perfil315.php' border=0><br></br></center>";

?>
<HR>
<center><h3>Atenuación cada 45º</h3></center>

<TABLE BORDER='3' ALIGN='center'>
<TR>
<TH>Distancia </br>[Km]</TH>
<TH>0º </br>[dBuV/m]</TH>
<TH>45º</br>[dBuV/m]</TH>
<TH>90º</br>[dBuV/m]</TH>
<TH>135º</br>[dBuV/m]</TH>
<TH>180º</br>[dBuV/m]</TH>
<TH>225º</br>[dBuV/m]</TH>
<TH>270º</br>[dBuV/m]</TH>
<TH>315º</br>[dBuV/m]</TH>
</TR>
<TR>
<TD>5</TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 1p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>
<TR>
<TD>10</TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 2p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>
<TR>
<TD>15</TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 3p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>20</TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 4p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>25</TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 5p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>30</TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 6p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>35</TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 7p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>40</TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 8p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>45</TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 9p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>50</TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 10p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>55</TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 11p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>60</TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 12p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>65</TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 13p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>70</TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 14p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>75</TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 15p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>80</TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 16p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>85</TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 17p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>90</TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 18p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>95</TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 19p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

<TR>
<TD>100</TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones0.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones45.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones90.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones135.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones180.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones225.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones270.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
<?php $attn = shell_exec('sed -n 20p atenuaciones315.ttxt'); ?>
<TD><?php echo $attn;  ?></TD>
</TR>

</TABLE>
<HR>
<?
echo "<center><h4>Atenuación de 0º</h4></a></h4></br><img align = 'center' src='attn0.php' border=0><br></br></center>";
echo "<center><h4>Atenuación de 45º</h4></a></h4></br><img align = 'center' src='attn45.php' border=0><br></br></center>";
echo "<center><h4>Atenuación de 90º</h4></a></h4></br><img align = 'center' src='attn90.php' border=0><br></br></center>";
echo "<center><h4>Atenuación de 135º</h4></a></h4></br><img align = 'center' src='attn135.php' border=0><br></br></center>";
echo "<center><h4>Atenuación de 180º</h4></a></h4></br><img align = 'center' src='attn180.php' border=0><br></br></center>";
echo "<center><h4>Atenuación de 225º</h4></a></h4></br><img align = 'center' src='attn225.php' border=0><br></br></center>";
echo "<center><h4>Atenuación de 270º</h4></a></h4></br><img align = 'center' src='attn270.php' border=0><br></br></center>";
echo "<center><h4>Atenuación de 315º</h4></a></h4></br><img align = 'center' src='attn315.php' border=0><br></br></center>";

shell_exec('echo 0 > lock.splat');
//Fin del condicionante lock.splat
}
}
else {
echo "<h1 color: ff0000>La aplicación está siendo utilizada, por favor inténtelo mas tarde</h1>";
}
shell_exec('rm -f *.txt *.ttxt *.lrp *.ppm *.geo *.scf ./geo/* ./klm/* ./txt/* ./temporales/*');
?>  

<br></br>

<form action="splat.php" method="post">
<input type="submit" name="Volver" value="VOLVER"> 
</form>
