<!-- ************************************************************************
*      SPLAT: An RF Signal Propagation Loss and Terrain Analysis Tool       *
*			  Last update: 15-Mar-2007			    *
*****************************************************************************
*	     Project started in 1997 by John A. Magliacane, KD2BD 	    *
*****************************************************************************
*									    *
*     Extensively modified by J. D. McDonald in Jan. 2004 to include        *
*    the Longley-Rice propagation model using C++ code from NTIA/ITS.	    *
*									    *
*              See: http://flattop.its.bldrdoc.gov/itm.html                 *
*									    *
*****************************************************************************
*                                                                           *
* This program is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU General Public License as published by the     *
* Free Software Foundation; either version 2 of the License or any later    *
* version.								    *
*									    *
* This program is distributed in the hope that it will useful, but WITHOUT  *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or     *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License     *
* for more details.							    *
*									    *
*****************************************************************************
 
*****************************************************************************
*       	PHP Graphic User Interface by Charles Escobar               *	
*****************************************************************************  
  -->
<script type="text/javascript"><!--//--><![CDATA[//><!--
   
function prepareTargetBlank(){
   var className = 'external';
   var as = document.getElementsByTagName('a');
   for(i=0;i<as.length;i++){
      var a = as[i];
      r=new RegExp("(^| )"+className+"($| )");
      if(r.test(a.className)){
         a.onclick = function(){
            window.open(this.href);
            return false;
         }
      }
    }
}
   
window.onload = prepareTargetBlank;
   
//--><!]]></script>


<HEAD>
  <META http-equiv="Content-Type" content="text/html; charset=utf-8">
  <TITLE>SPLAT! PHP GUI --- A Terrestrial RF Path Analysis Application For
  Linux/Unix</TITLE>
</HEAD>
<BODY bgcolor="#F6E39E" background="./images/mainback.jpg">
<CENTER>
    <FONT face="Luxi Sans" size="4" color="#AF0000"><IMG src=
    "./images/splatlogo.gif" alt="SPLAT! Because The World Isn't Flat"></FONT>
  </CENTER>

<HR noshade>

<?php;

//borrado de los archivos de cálculos previos
shell_exec('rm -f *.txt *.lro *.lrp; rm ./kml/* ./lro/*');

$lock = shell_exec("cat ./lock.splat");
if ($lock==0) {
shell_exec('echo 1 > lock.splat');

//Factor de corrección para coordenadas en Ecuador +$dezpl seg west y -$dezpl seg sur
//Latitud norte
$dezpl=0;

//Determinación de coordenadas sur 
if ($surtx=="ON") {
$lat_gradotx= -$lat_gradotx;
$lat_minutotx= -$lat_minutotx; 
$lat_segundotx= -$lat_segundotx-$dezpl;
if ($lat_segundotx < -60) { 
$lat_segundotx= $lat_segundotx+60;
$lat_minutotx = $lat_minutotx-1; 
}
}
else {
$lat_segundotx= $lat_segundotx-$dezpl; 
if ($lat_segundotx < 0) { 
$lat_segundotx= $lat_segundotx+60;
$lat_minutotx= $lat_minutotx-1;
}
}

if ($surrx=="ON") {
$lat_gradorx= -$lat_gradorx;
$lat_minutorx= -$lat_minutorx;
$lat_segundorx= -$lat_segundorx-$dezpl; 
if ($lat_segundorx < -60) { 
$lat_segundorx= $lat_segundorx+60;
$lat_minutorx= $lat_minutorx-1;
}
}
else {
$lat_segundorx= $lat_segundorx-$dezpl; 
if ($lat_segundorx < 0) { 
$lat_segundorx= $lat_segundorx+60;
$lat_minutorx= $lat_minutorx-1;
}
}

//Creación del archivo /tmp/tx_site2.qth 
if ($tx2=="ON") {

if ($surtx2=="ON") {
$lat_gradotx2= -$lat_gradotx2;
$lat_minutotx2= -$lat_minutotx2;
$lat_segundotx2= -$lat_segundotx2-$dezpl; 
if ($lat_segundot2x < -60) { 
$lat_segundotx2= $lat_segundotx2+60;
$lat_minutotx2= $lat_minutotx2-1;
} 
}
else {
$lat_segundotx2= $lat_segundotx2-$dezpl; 
if ($lat_segundotx2 < 0) { 
$lat_segundotx2= $lat_segundotx2+60;
$lat_minutotx2= $lat_minutotx2-1;
}
}
//Factor de corrección west
$long_segundotx2=$long_segundotx2+$dezpl;
if ($long_segundotx2 > 60) {
$long_segundotx2=$long_segundotx2-60;
$long_minutotx2=$long_minutotx2+1;
}

shell_exec('touch /tmp/tx_site2.qth');
shell_exec('echo  "" > /tmp/tx_site2.qth');
$latitudtx2=$lat_gradotx2 ." ". $lat_minutotx2 ." " . $lat_segundotx2;
$longitudtx2=$long_gradotx2 ." ". $long_minutotx2 ." " . $long_segundotx2; 
$gestor = fopen("/tmp/tx_site2.qth", "r+");
fwrite($gestor, $tx_site2  , 26);
shell_exec('echo  "" >> /tmp/tx_site2.qth');
$gestor = fopen("/tmp/tx_site2.qth", "a+");
fwrite($gestor, $latitudtx2  , 26); 
shell_exec('echo  "" >> /tmp/tx_site2.qth');
$gestor = fopen("/tmp/tx_site2.qth", "a+");
fwrite($gestor, $longitudtx2 , 26);
shell_exec('echo  "" >> /tmp/tx_site2.qth');
$gestor = fopen("/tmp/tx_site2.qth", "a+");
fwrite($gestor, $h_tx2 . " m" , 26);  
shell_exec('echo  "" >> /tmp/tx_site2.qth');
$txx2="/tmp/tx_site2.qth";
}

//Creación del archivo /tmp/tx_site3.qth 
if ($tx3=="ON") { 

if ($surtx3=="ON") {
$lat_gradotx3= -$lat_gradotx3;
$lat_minutotx3= -$lat_minutotx3;
$lat_segundotx3= -$lat_segundotx3-$dezpl; 
if ($lat_segundotx3 < -60) { 
$lat_segundotx3= $lat_segundotx3+60;
$lat_minutotx3= $lat_minutotx3-1;
} 
}
else {
$lat_segundotx3= $lat_segundotx3-$dezpl; 
if ($lat_segundotx3 < 0) { 
$lat_segundotx3= $lat_segundotx3+60;
$lat_minutotx3= $lat_minutotx3-1;
}
}
//Factor de corrección west
$long_segundotx3=$long_segundotx3+$dezpl;
if ($long_segundotx3 > 60) {
$long_segundotx3=$long_segundotx3-60;
$long_minutotx3=$long_minutotx3+1;
}

shell_exec('touch /tmp/tx_site3.qth');
shell_exec('echo  "" > /tmp/tx_site3.qth');
$latitudtx3=$lat_gradotx3 ." ". $lat_minutotx3 ." " . $lat_segundotx3;
$longitudtx3=$long_gradotx3 ." ". $long_minutotx3 ." " . $long_segundotx3; 
$gestor = fopen("/tmp/tx_site3.qth", "r+");
fwrite($gestor, $tx_site3  , 36);
shell_exec('echo  "" >> /tmp/tx_site3.qth');
$gestor = fopen("/tmp/tx_site3.qth", "a+");
fwrite($gestor, $latitudtx3  , 36); 
shell_exec('echo  "" >> /tmp/tx_site3.qth');
$gestor = fopen("/tmp/tx_site3.qth", "a+");
fwrite($gestor, $longitudtx3 , 36); 
shell_exec('echo  "" >> /tmp/tx_site3.qth');
$gestor = fopen("/tmp/tx_site3.qth", "a+");
fwrite($gestor, $h_tx3 . " m" , 36);  
shell_exec('echo  "" >> /tmp/tx_site3.qth');
$txx3="/tmp/tx_site3.qth";
} 

//Creación del archivo /tmp/tx_site4.qth 
if ($tx4=="ON") { 

if ($surtx4=="ON") {
$lat_gradotx4= -$lat_gradotx4;
$lat_minutotx4= -$lat_minutotx4;
$lat_segundotx4= -$lat_segundotx4-$dezpl; 
if ($lat_segundotx4 < -60) { 
$lat_segundotx4= $lat_segundotx4+60;
$lat_minutotx4= $lat_minutotx4-1;
} 
}
else {
$lat_segundotx4= $lat_segundotx4-$dezpl; 
if ($lat_segundotx4 < 0) { 
$lat_segundotx4= $lat_segundotx4+60;
$lat_minutotx4= $lat_minutotx4-1;
}
} 
//Factor de corrección west
$long_segundotx4=$long_segundotx4+$dezpl;
if ($long_segundotx4 > 60) {
$long_segundotx4=$long_segundotx4-60;
$long_minutotx4=$long_minutotx4+1;
}

shell_exec('touch /tmp/tx_site4.qth');
shell_exec('echo  "" > /tmp/tx_site4.qth');
$latitudtx4=$lat_gradotx4 ." ". $lat_minutotx4 ." " . $lat_segundotx4;
$longitudtx4=$long_gradotx4 ." ". $long_minutotx4 ." " . $long_segundotx4; 
$gestor = fopen("/tmp/tx_site4.qth", "r+");
fwrite($gestor, $tx_site4  , 46);
shell_exec('echo  "" >> /tmp/tx_site4.qth');
$gestor = fopen("/tmp/tx_site4.qth", "a+");
fwrite($gestor, $latitudtx4  , 46); 
shell_exec('echo  "" >> /tmp/tx_site4.qth');
$gestor = fopen("/tmp/tx_site4.qth", "a+");
fwrite($gestor, $longitudtx4 , 46); 
shell_exec('echo  "" >> /tmp/tx_site4.qth');
$gestor = fopen("/tmp/tx_site4.qth", "a+");
fwrite($gestor, $h_tx4 . " m" , 46);  
shell_exec('echo  "" >> /tmp/tx_site4.qth');
$txx4="/tmp/tx_site4.qth";
} 

$potencia=10*Log10($pottx*1000);
$erpdbm=$potencia+$antenatx+$antenarx;
$zz=$erpdbm/10;
$erp=POW(10,$zz)/1000;


//Creación del archivo /tmp/splat.lrp 
shell_exec('touch splat.lrp');
shell_exec('echo  '.$edc.' "; Earth Dielectric Constant (Relative permittivity)" > splat.lrp');
shell_exec('echo  '.$ec.' "; Earth Conductivity (Siemens per meter)" >> splat.lrp');
shell_exec('echo  '.$abc.' "; Atmospheric Bending Constant (N-Units)" >> splat.lrp');
shell_exec('echo  '.$fmhz.' "; Frequency in MHz (20 MHz to 20 GHz)" >> splat.lrp');
shell_exec('echo  '.$rc.' "; Radio Climate" >> splat.lrp');
shell_exec('echo  '.$pol.' "; Polarization (0 = Horizontal, 1 = Vertical)" >> splat.lrp');
shell_exec('echo  '.$fs.' "; Fraction of situations" >> splat.lrp');
shell_exec('echo  '.$ft.' "; Fraction of time" >> splat.lrp');
shell_exec('echo  '.$erp.' "; Transmitter Effective Radiated Power in Watts (optional)" >> splat.lrp');
//shell_exec('echo  "" >> splat.lrp');

//Creación del archivo /tmp/tx_site.qth 
//Factor de corrección west
$long_segundotx=$long_segundotx+$dezpl;
if ($long_segundotx > 60) {
$long_segundotx=$long_segundotx-60;
$long_minutotx=$long_minutotx+1;
}

shell_exec('touch /tmp/tx_site.qth');
shell_exec('echo  "" > /tmp/tx_site.qth');
$latitudtx=$lat_gradotx ." ". $lat_minutotx ." " . $lat_segundotx;
$longitudtx=$long_gradotx ." ". $long_minutotx ." " . $long_segundotx;
$gestor = fopen("/tmp/tx_site.qth", "r+");
fwrite($gestor, $tx_site  , 26);
shell_exec('echo  "" >> /tmp/tx_site.qth');
$gestor = fopen("/tmp/tx_site.qth", "a+");
fwrite($gestor, $latitudtx  , 26); 
shell_exec('echo  "" >> /tmp/tx_site.qth');
$gestor = fopen("/tmp/tx_site.qth", "a+");
fwrite($gestor, $longitudtx , 26);
shell_exec('echo  "" >> /tmp/tx_site.qth');
$gestor = fopen("/tmp/tx_site.qth", "a+");
fwrite($gestor, $h_tx . " m" , 26); 
shell_exec('echo  "" >> /tmp/tx_site.qth');


//Creación del archivo /tmp/rx_site.qth
//Factor de corrección west
$long_segundorx=$long_segundorx+$dezpl;
if ($long_segundorx > 60) {
$long_segundorx=$long_segundorx-60;
$long_minutorx=$long_minutorx+1;
}
shell_exec('touch /tmp/rx_site.qth');
shell_exec('echo  "" > /tmp/rx_site.qth');
$latitudrx=$lat_gradorx ." ". $lat_minutorx ." " . $lat_segundorx;
$longitudrx=$long_gradorx ." ". $long_minutorx ." " . $long_segundorx;
$gestor = fopen("/tmp/rx_site.qth", "r+");
fwrite($gestor, $rx_site  , 26);
shell_exec('echo  "" >> /tmp/rx_site.qth');
$gestor = fopen("/tmp/rx_site.qth", "a+");
fwrite($gestor, $latitudrx  , 26);
shell_exec('echo  "" >> /tmp/rx_site.qth');
$gestor = fopen("/tmp/rx_site.qth", "a+");
fwrite($gestor, $longitudrx , 26);
shell_exec('echo  "" >> /tmp/rx_site.qth');
$gestor = fopen("/tmp/rx_site.qth", "a+");
fwrite($gestor, $h_rx . " m" , 26);
shell_exec('echo  "" >> /tmp/rx_site.qth');


//Cálculos de acuerdo a la selección de opciones por el usuario 

$frec=$fmhz;
$ttxx=$tx2 or $tx3 or $tx4;

if ($metric=="ON") {
$metric="-metric";
} 

if ($sb=="ON") {
$sb="-b limites.dat -s sitios.dat";
}

if ($oppm=="ON") {
shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth '.$metric.' '.$sb.' -d /opt/splat/sdf -m '.$radio.' -o temporales/'.$tx_site.'-'.$rx_site.'.ppm'); 
shell_exec('convert temporales/'.$tx_site.'-'.$rx_site.'.ppm -resize 640x640 temporales/'.$tx_site.'-'.$rx_site.'.png'); 

echo "<center><h4>Mapa topográfico con la trayectoria entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudappm.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br>(Click sobre el mapa para descargarlo)</br><a href='./temporales/".$tx_site."-".$rx_site.".ppm'><img align = 'center' src='./temporales/".$tx_site."-".$rx_site.".png' border=0></a><br></br></center>";
echo "<br></br>";
}
echo "<HR noshade>";
if ($p=="ON") {

shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth '.$metric.' -d /opt/splat/sdf -m '.$radio.' -p /tmp/perfil.png');
if ($ttxx==ON) {
echo "<center><h4>Perfil del terreno entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudap.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><img align = 'center' src='perfil-1.php' border=0><br></br></br></center>";
}
else{
echo "<center><h4>Perfil del terreno entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudap.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><img align = 'center' src='perfil.php' border=0><br></br></br></center>";
}
if ($tx2==ON) {
echo "<center><h4>Perfil del terreno entre $rx_site y $tx_site2&nbsp;&nbsp;<a href='./ayuda/ayudap.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><img align = 'center' src='perfil-2.php' border=0><br></br></br></center>";
}
if ($tx3==ON) {
echo "<center><h4>Perfil del terreno entre $rx_site y $tx_site3&nbsp;&nbsp;<a href='./ayuda/ayudap.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><img align = 'center' src='perfil-3.php' border=0><br></br></br></center>";
}
if ($tx4==ON) {
echo "<center><h4>Perfil del terreno entre $rx_site y $tx_site4&nbsp;&nbsp;<a href='./ayuda/ayudap.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><img align = 'center' src='perfil-4.php' border=0><br></br></br></center>";
}

}
echo "<HR noshade>";
if ($e=="ON") {
shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth '.$metric.' -d /opt/splat/sdf -m '.$radio.' -e /tmp/elevacion.png');
if ($ttxx==ON) {
echo "<center><h4>Angulo de elevación entre $rx_site y $tx_site &nbsp;&nbsp;<a href='./ayuda/ayudae.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='elevacion-1.php' border=0><br></br></center>";
}
else{
echo "<center><h4>Angulo de elevación entre $rx_site y $tx_site &nbsp;&nbsp;<a href='./ayuda/ayudae.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='elevacion.php' border=0><br></br></center>";
}
if ($tx2==ON) {
echo "<center><h4>Angulo de elevación entre $rx_site y $tx_site2 &nbsp;&nbsp;<a href='./ayuda/ayudae.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='elevacion-2.php' border=0><br></br></center>";
}
if ($tx3==ON) {
echo "<center><h4>Angulo de elevación entre $rx_site y $tx_site3 &nbsp;&nbsp;<a href='./ayuda/ayudae.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='elevacion-3.php' border=0><br></br></center>";
}
if ($tx4==ON) {
echo "<center><h4>Angulo de elevación entre $rx_site y $tx_site4 &nbsp;&nbsp;<a href='./ayuda/ayudae.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='elevacion-4.php' border=0><br></br></center>";
}
}

echo "<HR noshade>";
if ($h=="ON") {
shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth '.$metric.' -d /opt/splat/sdf -m '.$radio.' -h /tmp/altura.png'); 
if ($ttxx==ON) {
echo "<center><h4>Altura referenciada a LDV entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudahldv.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='altura-1.php' border=0><br></br></center>";
}
else{
echo "<center><h4>Altura referenciada a LDV entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudahldv.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='altura.php' border=0><br></br></center>";
}
if ($tx2==ON) {
echo "<center><h4>Altura referenciada a LDV entre $rx_site y $tx_site2&nbsp;&nbsp;<a href='./ayuda/ayudahldv.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='altura-2.php' border=0><br></br></center>";
}
if ($tx3==ON) {
echo "<center><h4>Altura referenciada a LDV entre $rx_site y $tx_site3&nbsp;&nbsp;<a href='./ayuda/ayudahldv.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='altura-3.php' border=0><br></br></center>";
}
if ($tx4==ON) {
echo "<center><h4>Altura referenciada a LDV entre $rx_site y $tx_site4&nbsp;&nbsp;<a href='./ayuda/ayudahldv.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='altura-4.php' border=0><br></br></center>";
}
}
echo "<HR noshade>";
if ($H1=="ON") {
shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth '.$metric.' -d /opt/splat/sdf -m '.$radio.' -H /tmp/hnormalizada.png'); 
if ($ttxx==ON) { 
echo "<center><h4>Altura normalizada entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudaHn.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='hnormalizada-1.php' border=0><br></br></center>";
}
else{
echo "<center><h4>Altura normalizada entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudaHn.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='hnormalizada.php' border=0><br></br></center>";
}
if ($tx2==ON) {
echo "<center><h4>Altura normalizada entre $rx_site y $tx_site2&nbsp;&nbsp;<a href='./ayuda/ayudaHn.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='hnormalizada-2.php' border=0><br></br></center>";
}
if ($tx3==ON) {
echo "<center><h4>Altura normalizada entre $rx_site y $tx_site3&nbsp;&nbsp;<a href='./ayuda/ayudaHn.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='hnormalizada-3.php' border=0><br></br></center>";
}
if ($tx4==ON) {
echo "<center><h4>Altura normalizada entre $rx_site y $tx_site4&nbsp;&nbsp;<a href='./ayuda/ayudaHn.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='hnormalizada-4.php' border=0><br></br></center>";
}
}
echo "<HR noshade>";
if ($f=="ON") {
shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth '.$metric.' -d /opt/splat/sdf -m '.$radio.' -f '.$frec.' -H /tmp/fresnel.png'); 
if ($ttxx==ON) { 
echo "<center><h4>Zona de Fresnel entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudaf.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='fresnel-1.php' border=0><br></br></center>";
}
else{
echo "<center><h4>Zona de Fresnel entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudaf.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='fresnel.php' border=0><br></br></center>";
}
if ($tx2==ON) {
echo "<center><h4>Zona de Fresnel entre $rx_site y $tx_site2&nbsp;&nbsp;<a href='./ayuda/ayudaf.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='fresnel-2.php' border=0><br></br></center>";
}
if ($tx3==ON) {
echo "<center><h4>Zona de Fresnel entre $rx_site y $tx_site3&nbsp;&nbsp;<a href='./ayuda/ayudaf.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='fresnel-3.php' border=0><br></br></center>";
}
if ($tx4==ON) {
echo "<center><h4>Zona de Fresnel entre $rx_site y $tx_site4&nbsp;&nbsp;<a href='./ayuda/ayudaf.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='fresnel-4.php' border=0><br></br></center>";
}
}
echo "<HR noshade>";
if ($l=="ON") {
shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth '.$metric.' -d /opt/splat/sdf -m '.$radio.' -l /tmp/perdidas.png'); 
if ($ttxx==ON) { 
echo "<center><h4>Pérdidas por trayectoria entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudal.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='perdidas-1.php' border=0><br></br></center>";
}
else{
echo "<center><h4>Pérdidas por trayectoria entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudal.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='perdidas.php' border=0><br></br></center>";
}
if ($tx2==ON) {
echo "<center><h4>Pérdidas por trayectoria entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudal.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='perdidas-2.php' border=0><br></br></center>";
}
if ($tx3==ON) {
echo "<center><h4>Pérdidas por trayectoria entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudal.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='perdidas-3.php' border=0><br></br></center>";
}
if ($tx4==ON) {
echo "<center><h4>Pérdidas por trayectoria entre $rx_site y $tx_site&nbsp;&nbsp;<a href='./ayuda/ayudal.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br><img align = 'center' src='perdidas-4.php' border=0><br></br></center>";
}

}

echo "<HR noshade>";
if ($kml=="ON") { 
shell_exec('splat -t /tmp/tx_site.qth '.$txx2.' '.$txx3.' '.$txx4.' -r /tmp/rx_site.qth -kml; mv *.kml kml/');  
$k=shell_exec('ls *kml');
echo "<center><h4>Archivo kml para Google Earth&nbsp;&nbsp;<a href='./ayuda/ayudakml.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><a href=./kml/><img align = 'center' src='./images/download.png' border=0></a><br></br></center>"; 
				echo "<br></br>";
}
echo "<HR noshade>";
shell_exec('mv *lro lro/;mv *txt lro/');
echo "<center><h4>Archivos de resultados&nbsp;&nbsp;<a href='./ayuda/ayudares.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4><a href=./lro/><img align = 'center' src='./images/download.png' border=0></a><br></br></center>"; 
				echo "<br></br>";

echo "<HR noshade>";
echo "<h4>&nbsp;&nbsp;&nbsp;&nbsp;Parámetros Longley-Rice usados para los cálculos&nbsp;&nbsp;<a href='./ayuda/ayudaplr.php' class='external','HEIGHT=420,WIDTH=420,TOP=100,LEFT=100')'><img src='./images/ayuda.png' width='39' height='39'></a></h4></br>";
$a=system('ls *lrp', $retval);
echo "<br>";
$handle = @fopen("splat.lrp", "r");
if ($handle) {
    while (!feof($handle)) {
        $buffer = fgets($handle, 4096);
        echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" .$buffer."<br>";
    }
    fclose($handle);
}
echo "<br>";

echo "<h3>Cálculos de Radioenlace</h3>";

echo "<h4>Ganancias del Sistema</h4>";
echo "Potencia del transmisor: $potencia dBm";
echo "</br>";
echo "Ganancia Antena Tx; $antenatx dBd";
echo "</br>";
echo "Ganancia Antena Rx; $antenarx dBd";
echo "</br>";
$gtotal=$potencia+$antenatx+$antenarx;
echo "<b>Ganancia Total del Sistema: $gtotal dB</b>";

echo "</br>";
echo "<h4>Pérdidas del Sistema</h4>";
$distanciam=shell_exec('cat ./lro/'.$tx_site.'-to-'.$rx_site.'.txt|grep "Dis"|cut -d " " -f 4');
$distancia=$distanciam/0.62;
echo "Distancia del enlace: $distancia Km";
echo "</br>";
$perdidasl=32.5+20*LOG10($distancia)+20*LOG10($fmhz);
echo "Pérdidas en el espacio libre: $perdidasl dB";
echo "</br>";
$pitwom=shell_exec('cat ./lro/'.$tx_site.'-to-'.$rx_site.'.txt |grep "ITWOM Version 3.0 path loss"|cut -d " " -f 6');
echo "Pérdidas ITWOM:$pitwom dB";
echo "</br>";
echo "Pérdidas por Conectores y Línea de Transmisión: $cables dB";
$perdidalibre=$perdidasl+$cables;
echo "</br>";
echo "<b>Pérdida Total del Sistema (Solo espacio libre):$perdidalibre dB</b>";
$perdidaitwom=$pitwom+$cables;
echo "</br>";
echo "<b>Perdida total del Sistema (Considerando ITWOM):$perdidaitwom dB</b>";
$serlibre=$gtotal-$perdidalibre;
$seritwom=$gtotal-$perdidaitwom;
$umbrallibre=$serlibre-$umbral;
$umbralitwom=$seritwom-$umbral;

echo "<h4>Señal Efectiva Recibida</h4>";
echo "Señal Efectiva Recibida (Solo espacio libre):$serlibre dB";
echo "</br>";
echo "Señal Efectiva Recibida (Considerando ITWOM):$seritwom dB";
echo "</br>";
echo "<h4>Umbral de Recepción</h4>";
echo "Umbral de Recepción: $umbral dBm";
echo "</br>";
echo "<b>Umbral de Recepción (Solo espacio libre):$umbrallibre dB</b>";
echo "</br>";
echo "<b>Umbral de Recepción (Considerando ITWOM): $umbralitwom dB</b>"; 


shell_exec('echo 0 > lock.splat');

//Fin del condicionante lock.splat
}
else {
echo "<h1 color: ff0000>La aplicación está siendo utilizada, por favor inténtelo mas tarde</h1>";
}

?>

<br></br>
<form action="splat.php" method="post">
<input type="submit" name="Volver" value="VOLVER"> 
</form>
